import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class AppbarItem extends StatelessWidget {
  final String title;
  final IconData icon;
  final String desc;

  const AppbarItem(
      {super.key, required this.title, required this.icon, required this.desc});

  @override
  Widget build(BuildContext context) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Icon(
          icon,
          size: 36.r,
        ),
        8.horizontalSpace,
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              title,
              style: Style.interMedium(size: 20.r),
            ),
            Text(
              desc,
              style: Style.interSemi(
                  size: 24.r, ),
            )
          ],
        )
      ],
    );
  }
}
